<?php
/*
 * ARI YUI menu Joomla! module
 *
 * @package		ARI YUI Menu Joomla! module.
 * @version		1.0.0
 * @author		ARI Soft
 * @copyright	Copyright (c) 2009 www.ari-soft.com. All rights reserved
 * @license		GNU/GPL (http://www.gnu.org/copyleft/gpl.html)
 * 
 */

defined('ARI_FRAMEWORK_LOADED') or die('Direct Access to this location is not allowed.');

$menuId = $params['menuId'];
$menuPrefix = $params['menuPrefix'];
$menu = $params['menu'];
$level = $params['level'];
$parentId = $params['parentId'];
$j15 = $params['j15'];
$advSeparator = AriUtils2::getParam($params, 'advSeparator', false);
$isRegistered = $params['isRegistered'];
$isSpecial = $params['isSpecial'];
$selectedId = AriUtils2::getParam($params, 'selectedId', 0);
$menuDirection = AriUtils2::getParam($params, 'menuDirection', 'horizontal');
$isVertical = ($menuDirection != 'horizontal');
$flatMenu = array_values($menu);

$cssClass = ($level || $isVertical) ? 'yuimenu' : 'yuimenubar yuimenubarnav';
$hrefCssClass = ($level || $isVertical) ? 'yuimenuitemlabel' : 'yuimenubaritemlabel';
$menuItemClass = ($level || $isVertical) ? 'yuimenuitem' : 'yuimenubaritem';
$menuItemDisabledClass = ($level || $isVertical) ? 'yuimenuitem-disabled' : 'yuimenubaritem-disabled';
$hrefDisabledCssClass = ($level || $isVertical) ? 'yuimenuitemlabel-disabled' : 'yuimenubaritemlabel-disabled';
$selectedCssClass = ($level || $isVertical) ? 'yuimenuitem-selected' : 'yuimenubaritem-selected';
$hrefSelectedCssClass = ($level || $isVertical) ? 'yuimenuitemlabel-selected' : 'yuimenubaritemlabel-selected';

if ($params['remainActive'])
{
	$selectedCssClass .= ($level || $isVertical) ? ' yuimenuitem-active' : ' yuimenubaritem-active';
	$hrefSelectedCssClass .= ($level || $isVertical) ? ' yuimenuitemlabel-active' : ' yuimenubaritemlabel-active'; 
}
?>

<?php
if ($menu):
?>
	<div id="<?php echo $menuId; ?>" class="<?php echo $cssClass; ?>">
		<div class="bd">
			<ul<?php if (!$level): ?> class="first-of-type"<?php endif; ?>>
				<?php
					$i = 0;
					$j = -1;
					foreach ($menu as $menuItem):
						++$j;
						$hasChilds = isset($menuItem->children) && count($menuItem->children) > 0;
						if (!$menuItem->published || $menuItem->parent != $parentId) continue;

						if ($menuItem->type == 'separator' && !$hasChilds):
							$nextMenuItem = isset($flatMenu[$j + 1]) ? $flatMenu[$j + 1] : null;
							if (($nextMenuItem && $nextMenuItem->parent == $parentId) && ($level || $isVertical)):
								if (!$advSeparator):
				?>
			</ul>
			<ul>
				<?php
								else:
				?>
				<li class="<?php echo $menuItemClass . ' ' . $menuItemDisabledClass; ?> yuimenuitem-separator"><?php echo stripslashes(htmlspecialchars($menuItem->name)); ?></li>
				<?php
								endif;
							endif;
							continue;
						endif;

						$menuParams = $j15 ? new JParameter($menuItem->params) : new JRegistry($menuItem->params);
						$link = $menuItem->link;
						$menuType = $menuItem->type;
						$menuId = $menuItem->id;
						if ($menuItem->type == 'menulink' || $menuItem->type == 'alias')
						{
							$aliasId = $j15
								? AriJoomlaMenuHelper::getItemId($link)
								: $menuParams->get('aliasoptions');
							if ($aliasId > 0 && isset($menu[$aliasId]))
							{
								$aliasMenuItem =& $menu[$aliasId];
								$menuType = $aliasMenuItem->type;
								$link = $aliasMenuItem->link;
								$menuId = $aliasMenuItem->id;
							}
						}
						
						if ($link)
						{ 
							if ($menuType == 'url')
							{ 
								if ((strpos($link, 'index.php?') === 0) && (strpos($link, 'Itemid=') === false)) 
								{
									$link .= '&amp;Itemid=' . $menuId;
								}

								//$link .= (strpos($link, '?') !== false) ? '&' : '?';
								//$link .= 'Itemid=' . $menuItem->id;
							}
							else 
							{
								$router = JSite::getRouter();
								$link = $router->getMode() == JROUTER_MODE_SEF ? 'index.php?Itemid=' . $menuId : $link . '&Itemid=' . $menuId; 
							}
							
							if (strcasecmp(substr($link, 0, 4), 'http') && (strpos($link, 'index.php?') !== false))
							{
								$secure = $menuParams->def('secure', 0);
								$link = JRoute::_($link, true, $secure);
							} 
						} 

						$isSelected = ($menuItem->id == $selectedId);
						$isDisabled = ((!$isRegistered && $menuItem->access > ($j15 ? 0 : 1)) || 
							(!$isSpecial && $menuItem->access == ($j15 ? 2 : 3)));
						$id = $menuItem->id;
						$subMenu = $hasChilds ? $menuItem->children : null;
						$aAttr = array(
							'class' => $hrefCssClass . ($isDisabled ? ' ' . $hrefDisabledCssClass : '') . ($isSelected ? ' ' . $hrefSelectedCssClass : ''));
						if (!$isDisabled && $link)
						{ 
							$link = AriJoomlaUtils::getLink($link, false, false);
							switch ($menuItem->browserNav)
							{
								case 1:
									$aAttr['target'] = '_blank';
									break;
									
								case 2:
									$aAttr['onclick'] = "window.open(this.href,'targetWindow','toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,');return false;";
									break;
							}
						}
						else 
						{ 
							$link = 'javascript:void(0);';
						}
							
						$aAttr['href'] = $link;
				?>
					<li class="<?php echo $menuItemClass . (' yui-menu-item' . $menuItem->id) . ($isDisabled ? ' ' . $menuItemDisabledClass : '') . ($isSelected ? ' ' . $selectedCssClass : '') . (!$level && !$i ? ' first-of-type' : ''); ?>"><a<?php echo AriHtmlHelper::getAttrStr($aAttr); ?>><?php echo stripslashes(htmlspecialchars($menuItem->name)); ?></a>
					<?php
						if (!$isDisabled && $subMenu):
							AriTemplate::display(__FILE__,
								array('menuId' => $menuPrefix . $id,
									'menuPrefix' => $menuPrefix,
									'menu' => $subMenu,
									'level' => $level + 1,
									'parentId' => $id,
									'isRegistered' => $isRegistered,
									'isSpecial' => $isSpecial,
									'remainActive' => $params['remainActive'],
									'advSeparator' => $params['advSeparator'],
									'j15' => $j15));
						endif;
					?>
					</li>
				<?php
						++$i;
					endforeach;
				?>
			</ul>
		</div>
	</div>
<?php
endif; 
?>