/**
* Name: JD Tabs 
* @Copyright (C) 2011 Joomdesign.net @ All rights reserved
* @ Joomla! is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @ JD Tabs version 1.0
* Author: www.joomdesign.net
* Email: nicksonpro@gmail.com
**/
window.addEvent("domready",function(){
	var add_form = $('jd_add_form');
	// get the tabs data
	var tabs = JSON.decode($('jform_params_tabs_data').innerHTML);
	if(tabs == null || tabs == '') tabs = [];
	// fix problem with the accordion height
	$('TABS_MANAGER-options').addEvent('click', function(){
		if($('TABS_MANAGER-options').hasClass('pane-toggler')) {
			(function(){ $$('.pane-slider').setStyle('height', 'auto'); }).delay(750);
		}
	});
	// get public/register texts
	var public_text = add_form.getElements('.jd_add_content_access option')[0].innerHTML;
	var registered_text = add_form.getElements('.jd_add_content_access option')[1].innerHTML;
	var published_text = $('invisible').getElements('.jd_item_state span')[0].innerHTML;
	var unpublished_text = $('invisible').getElements('.jd_item_state span')[1].innerHTML;
	$('invisible').getElements('.jd_item_state span').destroy();
	//
	var add_form_scroll_wrap = $('jd_add_form').getElement('.height_scroll');
	var add_form_scroll = new Fx.Tween(add_form_scroll_wrap, { duration: 250, property: 'height', onComplete: function() { if(add_form_scroll_wrap.getSize().y > 0) add_form_scroll_wrap.setStyle('height', 'auto'); } });
	//
	$('jd_add_header').getElement('a').addEvent('click', function(e) {
		e.stop();
		add_form_scroll.start(add_form.getElement('.jd_add').getSize().y);
	});
	//
	$('jd_add_header').addEvent('click', function(e) {
		e.stop();
		add_form_scroll.start(add_form.getElement('.jd_add').getSize().y);
	});
	//
	var add_form_btns = add_form.getElements('.jd_add_submit a');
	// cancel button
	add_form_btns[1].addEvent('click', function(e) {
		if(e) e.stop();
		// clear the form
		add_form.getElement('.jd_add_name').set('value', '');
		add_form.getElement('.jd_add_content_module').setStyle('display', 'block');
		add_form.getElement('.jd_add_content_module').set('value', 'tab1');
		add_form.getElement('.jd_add_published').set('value', '1');
		add_form.getElement('.jd_add_content_access').set('value', 'public');
		// hide the form
		add_form_scroll_wrap.setStyle('height', add_form_scroll_wrap.getSize().y + 'px');
		add_form_scroll.start(0);
	});
	// save button
	add_form_btns[0].addEvent('click', function(e) {
		create_item('new');
	});
	// create item
	function create_item(source) {
		// duplicate item structure
		var item = $('invisible').getElement('.jd_item').clone();
		// get the values from the form
		var name = (source == 'new') ? add_form.getElement('.jd_add_name').get('value') : source.name;
		var type = (source == 'new') ? 'module' : source.type;
		var module = (source == 'new') ? add_form.getElement('.jd_add_content_module').get('value') :  source.content ;
	
		var published = (source == 'new') ? add_form.getElement('.jd_add_published').get('value') : source.published;
		var access = (source == 'new') ? add_form.getElement('.jd_add_content_access').get('value') : source.access;
		// put the values to the item
		item.getElement('.jd_item_name').innerHTML = name;
		item.getElement('.jd_item_state').setProperty('class', (published == 1) ? 'jd_item_state published' : 'jd_item_state unpublished');
		item.getElement('.jd_item_state').setProperty('title', (published == 1) ? published_text : unpublished_text);
		item.getElement('.jd_item_access').innerHTML = (access == 'public') ? public_text : registered_text;
		//
		// add the events to the item buttons
		//
		// fill the edit form
		var type = 'module';
		item.getElement('.jd_edit_name').set('value', name);
		item.getElement('.jd_edit_content_access').set('value', access);
		item.getElement('.jd_edit_published').set('value', published);
		item.getElement('.jd_edit_content_module').set('value', module);
		// edit
		item.getElements('.jd_item_edit').addEvent('click', function(e){
			if(e) e.stop();
			item.getElement('.jd_item_desc').fireEvent('click');
		});
		// edit
		item.getElement('.jd_item_desc').addEvent('click', function(e){
			if(e) e.stop();
			var scroller = item.getElement('.jd_editor_scroll');
			scroller.setStyle('height', scroller.getSize().y + "px");
			var fx = new Fx.Tween(scroller, { duration: 250, property: 'height', onComplete: function() { if(scroller.getSize().y > 0) scroller.setStyle('height', 'auto'); } });
			
			if(scroller.getSize().y > 0) {
				fx.start(0);
			} else {
				var items = item.getParent().getElements('.jd_item');
				
				items.each(function(it) {
					if(it != item) it.getElements('.jd_edit_submit a')[1].fireEvent('click');
				});
			
				fx.start(scroller.getElement('div').getSize().y);
			}
		});
		// publish / unpublish
		item.getElement('.jd_item_state').addEvent('click', function(e) {
			if(e) e.stop();
			var btn = item.getElement('.jd_item_state');
			if(btn.hasClass('published')) {
				item.getElement('.jd_edit_published').set('value', 0);
				btn.setProperty('class', 'jd_item_state unpublished');
				btn.setProperty('title', unpublished_text);
				item.getElements('.jd_edit_submit a')[0].fireEvent('click');
			} else {
				item.getElement('.jd_edit_published').set('value', 1);
				btn.setProperty('class', 'jd_item_state published');
				btn.setProperty('title', published_text);
				item.getElements('.jd_edit_submit a')[0].fireEvent('click');
			}
		});
		
		item.getElements('.jd_item_remove').addEvent('click', function(e){
			if(e) e.stop();
			// get all items list
			var items = item.getParent().getElements('.jd_item');
			// get the item ID on list
			var item_id = items.indexOf(item);
			// remove the object from the JSON array
			tabs.splice(item_id, 1);
			// remove the item from list
			item.destroy();
			// put the data to textarea field
			$('jform_params_tabs_data').innerHTML = JSON.encode(tabs);
		});
		// cancel edit
		item.getElements('.jd_edit_submit a')[1].addEvent('click', function(e) {
			if(e) e.stop();
			// hide the form
			var scroller = item.getElement('.jd_editor_scroll');
			scroller.setStyle('height', scroller.getSize().y + "px");
			new Fx.Tween(scroller, { duration: 250, property: 'height' }).start(0);
		});
		// save edit
		item.getElements('.jd_edit_submit a')[0].addEvent('click', function(e) {
			if(e) e.stop();
			// get the data from editor
			var name = item.getElement('.jd_edit_name').get('value');
			var type = 'module';
			var access = item.getElement('.jd_edit_content_access').get('value');
			var published = item.getElement('.jd_edit_published').get('value');
			var module = item.getElement('.jd_edit_content_module').get('value');
			// set the data in the JSON object
			var items = item.getParent().getElements('.jd_item');
			var item_id = items.indexOf(item);
			tabs[item_id] = {
				"name" : name,
				"type" : type,
				"content" : (type == 'module') ? module : htmlspecialchars(xhtml),
				"published" : published,
				"access" : access
			};
			// update the item content
			item.getElement('.jd_item_name').innerHTML = name;
			item.getElement('.jd_item_state').setProperty('class', (published == 1) ? 'jd_item_state published' : 'jd_item_state unpublished');
			item.getElement('.jd_item_state').setProperty('title', (published == 1) ? published_text : unpublished_text);
			item.getElement('.jd_item_access').innerHTML = (access == 'public') ? public_text : registered_text;
			// hide the form
			item.getElements('.jd_edit_submit a')[1].fireEvent('click');
			// put the data to textarea field
			$('jform_params_tabs_data').innerHTML = JSON.encode(tabs);
		});
		// order up 
		item.getElement('.jd_item_order_up').addEvent('click', function(e) {
			if(e) e.stop();
			var wrap = item.getParent();
			// get item ID
			var items = item.getParent().getElements('.jd_item');
			var item_id = items.indexOf(item);
			// check item ID
			if(item_id > 0) {
				var tmp = tabs[item_id - 1];
				tabs[item_id - 1] = tabs[item_id];
				tabs[item_id] = tmp;
				item.inject(item.getPrevious(), 'before');
				// refresh order buttons state
				if(items.length > 0) {
					wrap.getElements('.jd_item_order_down').setStyle('opacity', 1);
					wrap.getElements('.jd_item_order_up').setStyle('opacity', 1);
					wrap.getElement('.jd_item_order_up').setStyle('opacity', 0.3);
					wrap.getElements('.jd_item_order_down')[items.length - 1].setStyle('opacity', 0.3);
				}
				// put the data to textarea field
				$('jform_params_tabs_data').innerHTML = JSON.encode(tabs);
			}	
		});
		// order down
		item.getElement('.jd_item_order_down').addEvent('click', function(e) {
			if(e) e.stop();
			var wrap = item.getParent();
			// get item ID
			var items = wrap.getElements('.jd_item');
			var item_id = items.indexOf(item);
			// check item ID
			if(item_id < items.length - 1) {
				var tmp = tabs[item_id + 1];
				tabs[item_id + 1] = tabs[item_id];
				tabs[item_id] = tmp;
				item.inject(item.getNext(), 'after');
				// refresh order buttons state
				if(items.length > 0) {
					wrap.getElements('.jd_item_order_down').setStyle('opacity', 1);
					wrap.getElements('.jd_item_order_up').setStyle('opacity', 1);
					wrap.getElement('.jd_item_order_up').setStyle('opacity', 0.3);
					wrap.getElements('.jd_item_order_down')[items.length - 1].setStyle('opacity', 0.3);
				}
				// put the data to textarea field
				$('jform_params_tabs_data').innerHTML = JSON.encode(tabs);
			}		
		});
		//
		// put the data to object
		//
		if(source == 'new') { // only new objects
			tabs.push({
				"name" : name,
				"type" : type,
				"content" : module ,
				"published" : published,
				"access" : access
			});
			// clear and hide the form
			add_form_btns[1].fireEvent('click');
			// put the data to textarea field
			$('jform_params_tabs_data').innerHTML = JSON.encode(tabs);
		}
		// put the item to the list
		item.inject($('tabs_list'), 'bottom');
		// refresh order buttons state
		var wrap = item.getParent();
		var items = wrap.getElements('.jd_item');
		if(items.length > 0) {
			wrap.getElements('.jd_item_order_down').setStyle('opacity', 1);
			wrap.getElements('.jd_item_order_up').setStyle('opacity', 1);
			wrap.getElement('.jd_item_order_up').setStyle('opacity', 0.3);
			wrap.getElements('.jd_item_order_down')[items.length - 1].setStyle('opacity', 0.3);
		}
	}
	// generate the list
	tabs.each(function(tab) {
		create_item(tab);
	});
	// other form operations
	$$('.input-pixels').each(function(el){el.getParent().innerHTML = el.getParent().innerHTML + "<span class=\"unit\">px</span>"});
	$$('.input-percents').each(function(el){el.getParent().innerHTML = el.getParent().innerHTML + "<span class=\"unit\">%</span>"});
	$$('.input-minutes').each(function(el){el.getParent().innerHTML = el.getParent().innerHTML + "<span class=\"unit\">minutes</span>"});
	$$('.input-ms').each(function(el){el.getParent().innerHTML = el.getParent().innerHTML + "<span class=\"unit\">ms</span>"});
	// switchers
	$$('.jd_switch').each(function(el){
		el.setStyle('display','none');
		var style = (el.value == 1) ? 'on' : 'off';
		var switcher = new Element('div',{'class' : 'switcher-'+style});
		switcher.inject(el, 'after');
		switcher.addEvent("click", function(){
			if(el.value == 1){
				switcher.setProperty('class','switcher-off');
				el.value = 0;
			}else{
				switcher.setProperty('class','switcher-on');
				el.value = 1;
			}
		});
	});
	
	var link = new Element('', { 'href' : '#' })
	link.inject($$('div.panel')[$$('div.panel').length-1].getElement('h3'), 'bottom');
	link.addEvent('click', function(e) { e.stopPropagation(); });
	//
	$('TABS_MANAGER-options').getParent().getElement('.panelform .adminformlist li').setStyle('border', 'none');
});
// function to generate the updates list
// encode chars
function htmlspecialchars(string) {
    string = string.toString();
    string = string.replace(/&/g, '[ampersand]').replace(/</g, '[leftbracket]').replace(/>/g, '[rightbracket]');
    return string;
}
// decode chars
function htmlspecialchars_decode(string) {
	string = string.toString();
	string = string.replace(/\[ampersand\]/g, '&').replace(/\[leftbracket\]/g, '<').replace(/\[rightbracket\]/g, '>');
	return string;
}