/**
* Name: JD Tabs 
* @Copyright (C) 2011 Joomdesign.net @ All rights reserved
* @ Joomla! is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @ JD Tabs version 1.0
* Author: www.joomdesign.net
* Email: nicksonpro@gmail.com
**/
window.addEvent('domready', function(){
	$$('.JDTabs').each(function(el,i){
		var module_id = el.getProperty('id');
		var $G = $Gavick['JDTabs-'+module_id]; 
		var tabs = el.getElements('.JDTabsItem');
		var items = el.getElements('.JDTabss li');
		var animation = ($G['animation'] == 0) ? true : false;
		var currentTab = $G['active_tab'] - 1;
		var eventActivator = $G['activator'];
		var amount = tabs.length;
		var timer = false;
		var blank = false;
		var falsy_click = false;
		var animation_type = $G['animation_type'];
		var opacityFx = [];
		// prepare scroll effect
		var scrollFx = null; 
		if(animation_type == 'slider') {
			scrollFx = new Fx.Scroll(el.getElement(".JDTabsContainer1"), {duration: $G['animation_speed'], wait: 'ignore', wheelStops:false, transition: $G['animation_function']});
		}
		// initial settings for slider animation
		if(animation_type == 'slider') {
			var sum = 0;
			
			el.getElement('.JDTabsContainer0').setStyle('width', el.getElement('.JDTabsContainer2 .active').getSize().x + 'px');
			
			tabs.each(function(tab, i){ 
				var size = el.getElement('.JDTabsContainer2 .active').getSize().x;
				sum += size; 
				tab.setStyles({
					'position' : 'absolute',
					'left' : i * size + 'px',
					'width' : size + 'px'
				});
			});
			
			
			
			el.getElement('.JDTabsContainer2').setStyle('width', sum + 'px');
		}
		// initial settings for opacity animation
		if(animation_type == 'opacity') {
			tabs.each(function(tab, i){ 
				tab.setStyles({
					'left' : 0,
					'position' : 'absolute',
					'opacity' : tab.hasClass('active') ? 1 : 0
				});
				opacityFx[i] = new Fx.Tween(tab, {property: 'opacity', duration: $G['animation_speed'], wait: 'ignore'});
			});
		}
		// add events to tabs
		items.each(function(item, i){
			item.addEvent(eventActivator, function(){
				// specific operations for selected type of the animation
				if(animation_type == 'slider') {
					scrollFx.toElement(tabs[i]);
				} else {
					opacityFx[currentTab].start(0);
					opacityFx[i].start(1);
				}
				// common operations for both types of animation
				currentTab = i;
				if(!falsy_click) blank = true;
				else falsy_click = false;
				items.removeClass('active');
				item.addClass('active');
				if($G['cookie_save'] == 1) Cookie.write('JDTabs-' + module_id, i + 1, { domain: '/', duration: 256 });
			});
		});
		// add events to buttons
		if(el.getElement('.JDTabsButtonNext')) {
			el.getElement('.JDTabsButtonNext').addEvent('click', function() {
				if(currentTab < amount - 1) items[currentTab + 1].fireEvent(eventActivator);	
				else items[0].fireEvent(eventActivator);
			});
			
			el.getElement('.JDTabsButtonPrev').addEvent('click', function() {
				if(currentTab > 0) items[currentTab - 1].fireEvent(eventActivator);	
				else items[amount - 1].fireEvent(eventActivator);
			});
		}
		
		if($G["animation"] == 1){
			timer = (function(){
				if(!blank) {
					falsy_click = true;
					if(currentTab < amount - 1) items[currentTab + 1].fireEvent(eventActivator);	
					else items[0].fireEvent(eventActivator);
				} else {
					blank = false;
				}
			}).periodical($G["animation_interval"]);
		}
	});
});