<?php
/**
* Name: JD Tabs 
* @Copyright (C) 2011 Joomdesign.net @ All rights reserved
* @ Joomla! is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
* @ JD Tabs version 1.0
* Author: www.joomdesign.net
* Email: nicksonpro@gmail.com
**/

defined('JPATH_BASE') or die;

jimport('joomla.form.formfield');

class JFormFieldmanager extends JFormField {
	protected $type = 'manager';

	protected function getInput() {
		$add_form = '<div id="jd_manager"><div id="jd_add_header">'.JText::_('MOD_JD_FORM_ITEMS_CREATED').'<a href="#add">'.JText::_('MOD_JD_FORM_ITEM_ADD').'</a></div><div id="jd_add_form">'.$this->getForm('add').'</div></div>';
		
		$edit_form = $this->getForm('edit');
		
		$item_form = '<div id="invisible"><div class="jd_item"><div class="jd_item_desc"><span class="jd_item_name"></span><span class="jd_item_order_down" title="'.JText::_('MOD_JD_FORM_ITEM_ORDER_DOWN').'"></span><span class="jd_item_order_up" title="'.JText::_('MOD_JD_FORM_ITEM_ORDER_UP').'"></span><a href="#remove" class="jd_item_remove" title="'.JText::_('MOD_JD_FORM_ITEM_REMOVE').'">'.JText::_('MOD_JD_FORM_ITEM_REMOVE').'</a><a href="#edit" class="jd_item_edit" title="'.JText::_('MOD_JD_FORM_ITEM_EDIT').'">'.JText::_('MOD_JD_FORM_ITEM_EDIT').'</a><span class="jd_item_access"></span><span class="jd_item_state published"><span>'.JText::_('MOD_JD_FORM_ITEM_PUBLISHED').'</span><span>'.JText::_('MOD_JD_FORM_ITEM_UNPUBLISHED').'</span></span></div><div class="jd_editor_scroll"><div class="jd_item_editor">'.$edit_form.'</div></div></div></div>';
		
		$tabs_list = '<div id="tabs_list"></div>';
		$textarea = '<textarea name="'.$this->name.'" id="'.$this->id.'" rows="20" cols="50">'.$this->value.'</textarea>';
		return $item_form  . $tabs_list .$add_form. $textarea;
	}
	
	private function getForm($type = 'add') {
        $module_position_select = '<input type="text" class="jd_'.$type.'_content_module" />';
       
       	$form_name_tooltip = ($type == 'add') ? ' class="hasTip" title="' . JText::_('MOD_JD_FORM_NAME_TOOLTIP') . '"' : '';
        $form_name = '<p><label'.$form_name_tooltip.'>'.JText::_('MOD_JD_FORM_NAME').'</label><input type="text" class="jd_'.$type.'_name" /></p>';
        
        $form_type_tooltip = ($type == 'add') ? ' class="hasTip" title="' . JText::_('MOD_JD_FORM_TYPE_TOOLTIP') . '"' : '';
		$form_type = '<p><label'.$form_type_tooltip.'>'.JText::_('MOD_JD_FORM_TYPE').'</label><select class="jd_'.$type.'_type"><option value="module">'.JText::_('MOD_JD_TYPE_MODULE').'</option><option value="xhtml" selected="selected">'.JText::_('MOD_JD_TYPE_XHTML').'</option></select></p>';
		
		$form_access_level_tooltip = ($type == 'add') ? ' class="hasTip" title="' . JText::_('MOD_JD_FORM_ACCESS_TOOLTIP') . '"' : '';
		$form_access_level = '<p><label'.$form_access_level_tooltip.'>'.JText::_('MOD_JD_FORM_ACCESS').'</label><select class="jd_'.$type.'_content_access"><option value="public">'.JText::_('MOD_JD_FORM_ACCESS_PUBLIC').'</option><option value="registered">'.JText::_('MOD_JD_FORM_ACCESS_REGISTERED').'</option></select></p>';
		
		$form_content_tooltip = ($type == 'add') ? ' class="hasTip" title="' . JText::_('MOD_JD_FORM_CONTENT_TOOLTIP') . '"' : '';
		$form_content = '<p><label'.$form_content_tooltip.'>'.JText::_('MOD_JD_FORM_CONTENT').'</label>' . $module_position_select . '<p>';
		
		$form_published_tooltip = ($type == 'add') ? ' class="hasTip" title="' . JText::_('MOD_JD_FORM_PUBLISHED_TOOLTIP') . '"' : '';
		$form_published = '<p><label'.$form_published_tooltip.'>'.JText::_('MOD_JD_FORM_PUBLISHED').'</label><select class="jd_'.$type.'_published"><option value="1">'.JText::_('MOD_JD_PUBLISHED').'</option><option value="0">'.JText::_('MOD_JD_UNPUBLISHED').'</option></select></p>';
		
		$form_buttons = '<div class="jd_'.$type.'_submit"><a href="#save">'.JText::_('MOD_JD_FORM_SAVE').'</a><a href="#cancel">'.JText::_('MOD_JD_FORM_CANCEL').'</a></div>';
		
		$form = '<div class="height_scroll"><div class="jd_'.$type.'">'.$form_name.$form_access_level.$form_published.$form_content.$form_buttons.'</div></div>';
		
		return $form;
	}
}