<?php
/*
 * ARI Ext menu Joomla! module
 *
 * @package		ARI Ext Menu Joomla! module.
 * @version		1.0.0
 * @author		ARI Soft
 * @copyright	Copyright (c) 2009 www.ari-soft.com. All rights reserved
 * @license		GNU/GPL (http://www.gnu.org/copyleft/gpl.html)
 * 
 */

defined('ARI_FRAMEWORK_LOADED') or die('Direct Access to this location is not allowed.');

$menuId = AriUtils2::getParam($params, 'menuId', '');
$menu = $params['menu'];
$hlCurrentItem = $params['hlCurrentItem'];
$fullMenu = !empty($params['fullMenu']) ? $params['fullMenu'] : $menu;
$level = $params['level'];
$parentId = $params['parentId'];
$gid = $params['gid'];
$j15 = $params['j15'];
$selectedId = AriUtils2::getParam($params, 'selectedId', 0);
$direction = AriUtils2::getParam($params, 'direction');
$lang =& JFactory::getLanguage();
$langTag = $lang->get('tag');

$ulClass = $level == 0 ? 'ux-menu' : 'ux-menu-sub ux-menu-init-hidden';
if ($level == 0)
	$ulClass .= $direction == 'horizontal' ? ' ux-menu-horizontal' : ' ux-menu-vertical';	
?>

<?php
if ($menu):
?>
	<ul<?php if ($menuId): ?> id="<?php echo $menuId; ?>"<?php endif; ?> class="<?php echo $ulClass; ?>">
		<?php
			$i = 0;
			$j = -1;
			$menuCnt = count($menu);
			foreach ($menu as $menuItem):
				++$j;
				if (!$menuItem->published || ($j15 && $menuItem->access == 2 && $gid == 18) ||
					(!empty($menuItem->language) && $menuItem->language != '*' && $menuItem->language != $langTag))
					continue ;

				$hasChilds = isset($menuItem->children) && count($menuItem->children) > 0;
				if ($menuItem->parent != $parentId || ($menuItem->type == 'separator' && !$hasChilds)) continue;

				$menuParams = $j15 ? new JParameter($menuItem->params) : new JRegistry($menuItem->params);
				$link = $menuItem->link;
				$menuType = $menuItem->type;
				$menuId = $menuItem->id;
				if ($menuItem->type == 'menulink' || $menuItem->type == 'alias')
				{
					$aliasId = $j15
						? AriJoomlaMenuHelper::getItemId($link)
						: $menuParams->get('aliasoptions');
					if ($aliasId > 0 && isset($fullMenu[$aliasId]))
					{
						$aliasMenuItem =& $fullMenu[$aliasId];
						$menuType = $aliasMenuItem->type;
						$link = $aliasMenuItem->link;
						$menuId = $aliasMenuItem->id;
					}
				}

				$isSelected = ($menuItem->id == $selectedId);
				$id = $menuItem->id;
				$subMenu = $hasChilds ? $menuItem->children : null;
				$aAttr = array();
				if ($link)
				{
					if ($menuType == 'url')
					{ 
						if ((strpos($link, 'index.php?') === 0) && (strpos($link, 'Itemid=') === false)) 
						{
							$link .= '&amp;Itemid=' . $menuId;
						}
					}
					else 
					{
						$router = JSite::getRouter();
						$link = $router->getMode() == JROUTER_MODE_SEF ? 'index.php?Itemid=' . $menuId : $link . '&Itemid=' . $menuId; 
					}

					if (strcasecmp(substr($link, 0, 4), 'http') && (strpos($link, 'index.php?') !== false))
					{
						$secure = $menuParams->def('secure', 0);
						$link = JRoute::_($link, true, $secure);
					}
					
					$link = AriJoomlaUtils::getLink($link, false, false);
					switch ($menuItem->browserNav)
					{
						case 1:
							$aAttr['target'] = '_blank';
							break;
							
						case 2:
							$aAttr['onclick'] = "window.open(this.href,'targetWindow','toolbar=no,location=no,status=no,menubar=no,scrollbars=yes,resizable=yes,');return false;";
							break;
					}
				}
				else 
				{ 
					$link = 'javascript:void(0);';
				}
					
				$aAttr['href'] = $link;
				
				$liClass = $level == 0 ? 'ux-menu-item-main' : '';
				if ($hasChilds)
					$liClass .= ' ux-menu-item-parent';
				$liClass .= ' ux-menu-item' . $menuItem->id;
				if ($level == 0)
					$liClass .= ' ux-menu-item-parent-pos' . $i;
				if ($hlCurrentItem && $menuItem->id == $selectedId)
					$liClass .= ' current';
					
				$aClass = '';
				if ($i == 0)
					$aClass = 'ux-menu-link-first';
				if ($i == $menuCnt - 1)
					$aClass .= ' ux-menu-link-last';
				if ($hlCurrentItem && $menuItem->id == $selectedId)
					$aClass .= ' current';
				if ($hasChilds)
					$aClass .= ' ux-menu-link-parent';
				if ($aClass)
					$aAttr['class'] = $aClass;
		?>
			<li<?php if ($liClass): ?> class="<?php echo $liClass; ?>"<?php endif; ?>><a<?php echo AriHtmlHelper::getAttrStr($aAttr); ?>><?php echo stripslashes(htmlspecialchars($menuItem->name)); ?></a>
			<?php
				if ($subMenu):
					AriTemplate::display(__FILE__,
						array(
							'fullMenu' => $fullMenu,
							'menu' => $subMenu,
							'hlCurrentItem' => $hlCurrentItem,
							'level' => $level + 1,
							'parentId' => $id,
							'selectedId' => $selectedId,
							'gid' => $gid,
							'j15' => $j15));
				endif;
			?>
			</li>
		<?php
				++$i;
			endforeach;
		?>
	</ul>
<?php
endif; 
?>